/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.execution;

import com.floragunn.signals.accounts.AccountRegistry;
import com.floragunn.signals.execution.ExecutionEnvironment;
import com.floragunn.signals.execution.SimulationMode;
import com.floragunn.signals.execution.WatchExecutionContextData;
import com.floragunn.signals.watch.action.invokers.ActionInvocationType;
import com.floragunn.signals.watch.action.invokers.ActionInvoker;
import com.floragunn.signals.watch.common.HttpEndpointWhitelist;
import com.floragunn.signals.watch.common.HttpProxyConfig;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.client.Client;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.xcontent.NamedXContentRegistry;

public class WatchExecutionContext {
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ScriptService scriptService;
    private final Map<String, Object> metadata;
    private final ExecutionEnvironment executionEnvironment;
    private final ActionInvocationType actionInvocationType;
    private final AccountRegistry accountRegistry;
    private final WatchExecutionContextData contextData;
    private final WatchExecutionContextData resolvedContextData;
    private final SimulationMode simulationMode;
    private final HttpEndpointWhitelist httpEndpointWhitelist;
    private final HttpProxyConfig httpProxyConfig;
    private final String frontendBaseUrl;
    private final ActionInvoker actionInvoker;

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public WatchExecutionContext(Client client, ScriptService scriptService, NamedXContentRegistry xContentRegistry, AccountRegistry accountRegistry, ExecutionEnvironment executionEnvironment, ActionInvocationType actionInvocationType, WatchExecutionContextData contextData) {
        this(client, scriptService, xContentRegistry, accountRegistry, executionEnvironment, actionInvocationType, contextData, null, SimulationMode.FOR_REAL, null, null, null, null);
    }

    public WatchExecutionContext(Client client, ScriptService scriptService, NamedXContentRegistry xContentRegistry, AccountRegistry accountRegistry, ExecutionEnvironment executionEnvironment, ActionInvocationType actionInvocationType, WatchExecutionContextData contextData, WatchExecutionContextData resolvedContextData, SimulationMode simulationMode, HttpEndpointWhitelist httpEndpointWhitelist, HttpProxyConfig httpProxyConfig, String frontendBaseUrl, ActionInvoker actionInvoker) {
        this.client = client;
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.metadata = null;
        this.executionEnvironment = executionEnvironment;
        this.actionInvocationType = actionInvocationType;
        this.accountRegistry = accountRegistry;
        this.contextData = contextData;
        this.resolvedContextData = resolvedContextData;
        this.simulationMode = simulationMode;
        this.httpEndpointWhitelist = httpEndpointWhitelist;
        this.httpProxyConfig = httpProxyConfig;
        this.frontendBaseUrl = frontendBaseUrl;
        this.actionInvoker = actionInvoker;
    }

    public Client getClient() {
        return this.client;
    }

    public NamedXContentRegistry getxContentRegistry() {
        return this.xContentRegistry;
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public AccountRegistry getAccountRegistry() {
        return this.accountRegistry;
    }

    public WatchExecutionContextData getContextData() {
        return this.contextData;
    }

    public Map<String, Object> getTemplateScriptParamsAsMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.contextData.getTemplateScriptParamsAsMap());
        if (this.resolvedContextData != null) {
            result.put("resolved", this.resolvedContextData.getTemplateScriptParamsAsMap());
        }
        if (this.frontendBaseUrl != null && this.actionInvocationType == ActionInvocationType.ALERT && this.contextData.getWatch() != null) {
            String tenant = this.contextData.getWatch().getTenant();
            if ("_main".equals(tenant)) {
                tenant = "SGS_GLOBAL_TENANT";
            }
            result.put("ack_watch_link", this.frontendBaseUrl + "/app/searchguard-signals?sg_tenant=" + tenant + "#/watch/" + this.contextData.getWatch().getId() + "/ack/");
            if (this.actionInvoker != null && this.actionInvoker.getName() != null) {
                result.put("ack_action_link", this.frontendBaseUrl + "/app/searchguard-signals?sg_tenant=" + tenant + "#/watch/" + this.contextData.getWatch().getId() + "/ack/" + this.actionInvoker.getName() + "/");
            }
        }
        return result;
    }

    public WatchExecutionContext with(WatchExecutionContextData contextData, ActionInvoker actionInvoker) {
        return new WatchExecutionContext(this.client, this.scriptService, this.xContentRegistry, this.accountRegistry, this.executionEnvironment, this.actionInvocationType, contextData, this.resolvedContextData, this.simulationMode, this.httpEndpointWhitelist, this.httpProxyConfig, this.frontendBaseUrl, actionInvoker);
    }

    public WatchExecutionContext with(ActionInvocationType actionInvocationType) {
        return new WatchExecutionContext(this.client, this.scriptService, this.xContentRegistry, this.accountRegistry, this.executionEnvironment, actionInvocationType, this.contextData, this.resolvedContextData, this.simulationMode, this.httpEndpointWhitelist, this.httpProxyConfig, this.frontendBaseUrl, this.actionInvoker);
    }

    public WatchExecutionContext clone() {
        return new WatchExecutionContext(this.client, this.scriptService, this.xContentRegistry, this.accountRegistry, this.executionEnvironment, this.actionInvocationType, this.contextData != null ? this.contextData.clone() : null, this.resolvedContextData != null ? this.resolvedContextData.clone() : null, this.simulationMode, this.httpEndpointWhitelist, this.httpProxyConfig, this.frontendBaseUrl, this.actionInvoker);
    }

    public WatchExecutionContextData getResolvedContextData() {
        return this.resolvedContextData;
    }

    public ActionInvocationType getActionInvocationType() {
        return this.actionInvocationType;
    }

    public SimulationMode getSimulationMode() {
        return this.simulationMode;
    }

    public HttpEndpointWhitelist getHttpEndpointWhitelist() {
        return this.httpEndpointWhitelist;
    }

    public HttpProxyConfig getHttpProxyConfig() {
        return this.httpProxyConfig;
    }

    public String getFrontendBaseUrl() {
        return this.frontendBaseUrl;
    }
}

